----------------
title : C++ 레퍼런스 - string 의 erase 함수
cat_title : erase
ref_title : erase, basic_string::erase
path : /C++ Reference/string
publish_date : 2020-07-17
----------------

##@ cpp-ref-start

#@ erase

```cpp-formatted
basic_string& erase(size_type index = 0, size_type count = npos);  // (1)
iterator erase(const_iterator position);                           // (2)
iterator erase(const_iterator first, const_iterator last);         // (3)
```

`string` 에서 원하는 범위의 문자들을 삭제한다.

1. 첫번째 버전의 경우 `index` 로 부터, `count` 개의 문자들을 지운다. (`substr` 랑 비슷하다고 생각하면 된다.) 만일 `count` 가 문자열 끝을 넘어간다면, 그 이상 지우지 않는다.
2. `position` 위치에 있는 문자를 지운다.
3. `first` 부터 `last` 전 까지의 문자들을 지운다.

참고로 `index` 가 문자열의 길이보다 크다면, `std::out_of_range` 에외를 발생시킨다. 예외가 발생하였을 때는, 원래 문자열이 변경되지 않음이 보장된다.

### 인자들

* `index`	-	지울 첫번째 문자의 위치
* `count`	-	지울 문자의 개수
* `position`	-	지울 문자를 가리키는 반복자
* `first, last`	-	지울 문자들의 범위를 가리키는 반복자들.

### 리턴값

반복자를 사용하지 않는 경우 (1), 지워진 문자열이 리턴되고, 반복자를 사용하는 경우 (2, 3), 마지막으로 지워진 문자 바로 다음을 가리키는 반복자를 리턴한다.

### 예시

```cpp-formatted
#include <algorithm>
#include <iostream>
#include <string>

int main() {
  std::string s = "This is an example";
  std::cout << s << '\n';

  s.erase(0, 5);  // Erase "This "
  std::cout << s << '\n';

  s.erase(std::find(s.begin(), s.end(), ' '));  // Erase ' '
  std::cout << s << '\n';

  s.erase(s.find(' '));  // Trim from ' ' to the end of the string
  std::cout << s << '\n';
}
```

실행 결과

```exec
This is an example
is an example
isan example
isan
```

### 참고 자료

* `clear` - 문자열을 모두 지운다.